/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.arsenal.item;

import dev.doctor4t.arsenal.Arsenal;
import dev.doctor4t.arsenal.cca.ArsenalComponents;
import dev.doctor4t.arsenal.cca.WeaponOwnerComponent;
import dev.doctor4t.arsenal.entity.AnchorbladeEntity;
import dev.doctor4t.arsenal.index.ArsenalCosmetics;
import dev.doctor4t.arsenal.index.ArsenalEnchantments;
import dev.doctor4t.arsenal.index.ArsenalItems;
import dev.doctor4t.arsenal.index.ArsenalSounds;
import dev.doctor4t.arsenal.item.ArsenalWeaponItem;
import dev.doctor4t.arsenal.util.AnchorOwner;
import dev.doctor4t.arsenal.util.SweepParticleUtil;
import dev.doctor4t.ratatouille.item.CustomHitParticleItem;
import dev.doctor4t.ratatouille.item.CustomHitSoundItem;
import dev.doctor4t.ratatouille.util.TextUtils;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class AnchorbladeItem
extends class_1810
implements CustomHitParticleItem,
CustomHitSoundItem,
ArsenalWeaponItem {
    public AnchorbladeItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 blockStateClicked = context.method_8045().method_8320(context.method_8037());
        class_1657 user = context.method_8036();
        if (user != null && user.method_5715() && (blockStateClicked.method_26164(class_3481.field_15486) || blockStateClicked.method_27852(class_2246.field_16329)) && context.method_8045().field_9236) {
            if (ArsenalCosmetics.isSupporter(user.method_5667())) {
                WeaponOwnerComponent weaponOwnerComponent = (WeaponOwnerComponent)ArsenalComponents.WEAPON_OWNER_COMPONENT.get((Object)user.method_5998(context.method_20287()));
                Skin currentSkin = Skin.fromString(ArsenalCosmetics.getSkin(context.method_8041()));
                if (currentSkin == null) {
                    currentSkin = Skin.DEFAULT;
                }
                ArsenalCosmetics.setSkin(weaponOwnerComponent.getOwner(), context.method_8041(), Skin.getNext(currentSkin).getName());
                context.method_8036().method_5783(class_3417.field_22463, 0.5f, 1.0f);
                return class_1269.field_5812;
            }
            if (context.method_8045().field_9236) {
                user.method_43496((class_2561)class_2561.method_43471((String)"tooltip.supporter_only").method_27694(style -> style.method_36139(0xCC0000)));
                context.method_8036().method_5783(class_3417.field_15239, 0.5f, 1.0f);
            }
            return class_1269.field_5814;
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user instanceof AnchorOwner) {
            boolean reeling;
            AnchorOwner owner = (AnchorOwner)user;
            boolean bl = reeling = class_1890.method_8225((class_1887)ArsenalEnchantments.REELING, (class_1799)stack) > 0;
            if (owner.arsenal$isAnchorActive(hand, reeling)) {
                owner.arsenal$getAnchor(hand, reeling).setRecalled(user.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_31574(ArsenalItems.ANCHORBLADE));
                return class_1271.method_22431((Object)stack);
            }
            int riptide = class_1890.method_8202((class_1799)stack);
            if (riptide <= 0 || user.method_5721()) {
                if (!world.field_9236) {
                    stack.method_7956(1, (class_1309)user, p -> p.method_20236(user.method_6058()));
                    if (riptide == 0) {
                        AnchorbladeEntity anchorbladeEntity = new AnchorbladeEntity(world, (class_1309)user, stack);
                        anchorbladeEntity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 2.5f + (float)riptide * 0.5f, 1.0f);
                        owner.arsenal$setAnchor(hand, anchorbladeEntity);
                        world.method_8649((class_1297)anchorbladeEntity);
                        world.method_43129(null, (class_1297)anchorbladeEntity, ArsenalSounds.ITEM_ANCHORBLADE_THROW, class_3419.field_15248, 1.0f, 1.0f);
                        return class_1271.method_22427((Object)user.method_5998(hand));
                    }
                }
                user.method_7259(class_3468.field_15372.method_14956((Object)this));
            }
        }
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Skin skin = Skin.fromString(ArsenalCosmetics.getSkin(stack));
        if (skin != null && skin != Skin.DEFAULT) {
            tooltip.add((class_2561)class_2561.method_43470((String)(skin.tooltipName != null ? skin.tooltipName : TextUtils.formatValueString((String)skin.getName()))).method_27694(style -> style.method_36139(skin.getFirstColor())));
            if (skin.lore != null) {
                if (class_437.method_25442()) {
                    class_5250 translatable = class_2561.method_43471((String)skin.lore);
                    for (String line : translatable.getString().split("\n")) {
                        tooltip.add((class_2561)class_2561.method_43470((String)line).method_27694(style -> style.method_10977(class_124.field_1063)));
                    }
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.arsenal.hidden").method_27694(style -> style.method_10977(class_124.field_1063)));
                }
            }
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void spawnHitParticles(class_1657 player) {
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            Skin skin = Skin.DEFAULT;
            Skin toSkin = Skin.fromString(ArsenalCosmetics.getSkin(player.method_6047()));
            if (toSkin != null) {
                skin = toSkin;
            }
            class_3545<Integer, Integer> colorPair = skin.getRandomParticleColorPair();
            SweepParticleUtil.sendSweepPacketToClient(serverWorld, colorPair, player.method_23317() + (double)(-class_3532.method_15374((float)((float)((double)player.method_36454() * (Math.PI / 180))))), player.method_23323(0.5), player.method_23321() + (double)class_3532.method_15362((float)((float)((double)player.method_36454() * (Math.PI / 180)))));
        }
    }

    public void playHitSound(class_1657 player) {
        player.method_5783(ArsenalSounds.ITEM_ANCHORBLADE_HIT, 1.0f, (float)(1.0 + player.method_6051().method_43059() / 10.0));
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_7337();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            WeaponOwnerComponent weaponOwnerComponent = (WeaponOwnerComponent)ArsenalComponents.WEAPON_OWNER_COMPONENT.get((Object)stack);
            weaponOwnerComponent.setOwner(player.method_5667());
        }
    }

    public static enum Skin {
        DEFAULT(new int[]{-13949390}, new int[]{-15000805}, null, null),
        LUXINTRUS(new int[]{-1608161, -13134245, -5956681}, new int[]{-5748991, -15641022, -10022783}, "L'Ancre", "tooltip.arsenal.anchorblade_luxintrus"),
        CARRION(new int[]{-1450056}, new int[]{-6455186}, null, null),
        GILDED(new int[]{-934822}, new int[]{-1931724}, null, null),
        WINSWEEP(new int[]{-9216, -3770639}, new int[]{-4301056, -9091424}, "Wanchorblade", null),
        AMBESSA(new int[]{-5658201}, new int[]{-9802394}, "Crescent Blade", null);

        public final class_2960 chainTexture = Arsenal.id((String)(this.getName().equals("default") ? "textures/entity/chain.png" : "textures/entity/chain_" + this.getName() + ".png"));
        public final class_2960 anchorbladeEntityModel = Arsenal.id((String)(this.getName().equals("default") ? "item/anchorblade_in_hand" : "item/anchorblade_" + this.getName() + "_in_hand"));
        public final int[] colors;
        public final int[] shadowColors;
        @Nullable
        public final String tooltipName;
        @Nullable
        public final String lore;
        public final Random random;

        private Skin(@Nullable int[] colors, @Nullable int[] shadowColors, String tooltipName, String lore) {
            this.colors = colors;
            this.shadowColors = shadowColors;
            this.tooltipName = tooltipName;
            this.lore = lore;
            this.random = new Random();
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getFirstColor() {
            return this.colors[0];
        }

        public class_3545<Integer, Integer> getRandomParticleColorPair() {
            int i = this.random.nextInt(this.colors.length);
            return new class_3545((Object)this.colors[i], (Object)this.shadowColors[i]);
        }

        @Nullable
        public static Skin fromString(String name) {
            for (Skin skin : Skin.values()) {
                if (!skin.getName().equalsIgnoreCase(name)) continue;
                return skin;
            }
            return null;
        }

        public static Skin getNext(Skin skin) {
            Skin[] values = Skin.values();
            return values[(skin.ordinal() + 1) % values.length];
        }
    }
}

